<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Base\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Base\Entities\User;

class UserBaseTransformer extends BaseTransformer
{
    use Macroable;

    /**
     * @param User $user
     * @return array
     *
     * @OA\Schema(
     *     description="基本用户信息",
     *     type="object",
     *     schema="UserBase",
     *     @OA\Property(property="id", type="integer", description="用户ID"),
     *     @OA\Property(property="name", type="string", description="用户名"),
     *     @OA\Property(property="avatar", type="string", description="头像")
     * )
     */
    public function transform(User $user)
    {
        return map_attr($user, ['id', 'name', 'avatar']);
    }
}
