<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/15
 * Time: 9:47
 */
namespace Modules\Base\Transformers;

use Modules\Base\Entities\Enrollment;

class EnrollmentTransformer extends BaseTransformer
{
    protected $defaultIncludes = ['user'];

    public $availableIncludes=['activity'];

    protected $isMe = false;

    public function __construct($isMe = false)
    {
        parent::__construct();
        $this->isMe = $isMe;
    }

    /**
     * @OA\Schema(
     *     description="报名信息",
     *     type="object",
     *     schema="Enrollment",
     *     @OA\Property(property="id", type="integer", description="ID"),
     * )
     */
    public function transform(Enrollment $enrollment)
    {
        if ($this->isMe) {
            return map_attr($enrollment, ['id', 'mobile', 'name', 'company', 'pay_status', 'recommender', 'created_at']);
        }
        return map_attr($enrollment, ['id', 'created_at']);
    }

    public function includeUser($enrollment)
    {
        return $this->item($enrollment->user, new UserBaseTransformer());
    }

    public function includeActivity($enrollment)
    {
        return $this->item($enrollment->activity, new ActivityTransformer());
    }
}
