<?php

namespace Modules\Base\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Base\Entities\Activity;
use Modules\Base\Transformers\ActivityTransformer;

class ActivityController extends ApiController
{
    /**
     * 已报名用户信息列表
     * @return \Dingo\Api\Http\Response
     *
     * @OA\Get(
     *     tags={"活动"},
     *     summary="活动信息",
     *     path="/api/activities/{activity_id}",
     *     @OA\Parameter(
     *         name="activity_id",
     *         in="path",
     *         description="活动ID",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/Activity"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function detail(Activity $activity)
    {
        return $this->response->item($activity, new ActivityTransformer());
    }

    /**
     * @param Activity $activity
     * @return \Dingo\Api\Http\Response
     *
     *
     * @OA\Get(
     *     tags={"活动"},
     *     summary="活动列表",
     *     path="/api/activities",
     *     @OA\Parameter(
     *         name="type",
     *         in="query",
     *         description="类型 往期-wangqi  预展期-yuzhanqi  进行中-jinxingzhong",
     *         required=false,
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/Activity"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index(Activity $activity)
    {
        $activity = $activity->when(request('type', false), function ($query, $type) {
            if($type == 'wangqi'){
                $query->where('enroll_end','<',date('Y-m-d'));
            }else if($type == 'yuzhanqi'){
                $query->where('enroll_start','>',date('Y-m-d'));
            }else{
                $query->where('enroll_start','<',date('Y-m-d'));
                $query->where('enroll_end','>',date('Y-m-d'));
            }

        });
        return $this->response->paginator($activity->paginate(20), new ActivityTransformer());
    }
}
