<?php

namespace Modules\Base\Http\Controllers\Admin;

use Modules\Base\Entities\Activity;
use Modules\Base\Entities\Enrollment;
use App\Http\Controllers\Controller;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Controllers\HasResourceActions;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;
use SMG\Admin\Show;

class EnrollmentController extends Controller
{
    use HasResourceActions;

    /**
     * Index interface.
     *
     * @param Content $content
     * @return mixed
     */
    public function index(Content $content)
    {
        return $content
            ->header('报名列表')
            ->body($this->grid());
    }

    /**
     * Show interface.
     *
     * @param mixed   $id
     * @param Content $content
     * @return mixed
     */
    public function show($id, Content $content)
    {
        return $content
            ->header('Detail')
            ->description('description')
            ->body($this->detail($id));
    }

    /**
     * Edit interface.
     *
     * @param mixed   $id
     * @param Content $content
     * @return Content
     */
    public function edit($id, Content $content)
    {
        return $content
            ->header('Edit')
            ->description('description')
            ->body($this->form()->edit($id));
    }

    /**
     * Create interface.
     *
     * @param Content $content
     * @return Content
     */
    public function create(Content $content)
    {
        return $content
            ->header('Create')
            ->description('description')
            ->body($this->form());
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::Grid(new Enrollment, function ($grid) {
            $grid->model()->orderBy('id', 'desc');

            $grid->id('Id');
            $grid->column('activity.title', '活动');
            $grid->name('姓名');
            $grid->mobile('电话');
            $grid->company('公司');
            $grid->recommender('推荐人');
            $grid->pay_status('支付状态')->display(function ($value){return $value?'已支付':'未支付';});
            $grid->created_at('报名时间');

            $grid->disableCreateButton();
            $grid->enableExport();
            $grid->exporter(new EnrollmentsExporter());
            $grid->enableFilter();

            $grid->filter(function($filter){

                // 去掉默认的id过滤器
                $filter->disableIdFilter();

                $filter->equal('activity_id', '活动')->select(Activity::pluck('title', 'id'));
                $filter->equal('pay_status', '支付状态')->select(['未支付','已支付']);
                $filter->equal('name', '姓名');
                $filter->equal('mobile', '手机号');

            });

            $grid->actions(function ($actions){
                $actions->disableEdit();
                $actions->disableView();
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed   $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Enrollment::findOrFail($id));

        $show->id('Id');
        $show->user_id('User id');
        $show->activity_id('Activity id');
        $show->name('Name');
        $show->mobile('Mobile');
        $show->company('Company');
        $show->recommender('Recommender');
        $show->pay_status('Pay status');
        $show->created_at('Created at');
        $show->updated_at('Updated at');

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Enrollment);

        $form->number('user_id', 'User id');
        $form->number('activity_id', 'Activity id');
        $form->text('name', 'Name');
        $form->mobile('mobile', 'Mobile');
        $form->text('company', 'Company');
        $form->text('recommender', 'Recommender');
        $form->switch('pay_status', 'Pay status');

        return $form;
    }
}
