<?php

namespace Modules\Base\Http\Controllers\Admin;


use Modules\Base\Entities\Activity;
use App\Http\Controllers\Controller;
use SMG\Admin\Controllers\HasResourceActions;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;
use SMG\Admin\Show;

class ActivityController extends Controller
{
    use HasResourceActions;

    /**
     * Index interface.
     *
     * @param Content $content
     * @return mixed
     */
    public function index(Content $content)
    {
        return $content
            ->header('活动列表')
            ->body($this->grid());
    }

    /**
     * Show interface.
     *
     * @param mixed   $id
     * @param Content $content
     * @return mixed
     */
    public function show($id, Content $content)
    {
        return $content
            ->header('详情')
            ->body($this->detail($id));
    }

    /**
     * Edit interface.
     *
     * @param mixed   $id
     * @param Content $content
     * @return mixed
     */
    public function edit($id, Content $content)
    {
        return $content
            ->header('编辑')
            ->description('description')
            ->body($this->form()->edit($id));
    }

    /**
     * Create interface.
     *
     * @param Content $content
     * @return mixed
     */
    public function create(Content $content)
    {
        return $content
            ->header('新增')
            ->body($this->form());
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::Grid(new Activity, function($grid) {
            $grid->model()->withCount('enrollments')->orderBy('id', 'desc');
            $grid->id('Id');
            $grid->title('活动名称');
            $grid->start('开始时间');
            $grid->end('结束时间');
            $grid->enroll_start('报名开始时间');
            $grid->enroll_end('报名结束时间');
            $grid->sponsor('主办人');
            $grid->address('地址');
            $grid->contact('联系人');
            //$grid->content('Content');
            $grid->enrollments_count('报名人数');
            $grid->created_at('添加时间');
            //$grid->updated_at('Updated at');
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed   $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Activity::findOrFail($id));

        $show->id('Id');
        $show->title('Title');
        $show->start('Start');
        $show->end('End');
        $show->enroll_start('Enroll start');
        $show->enroll_end('Enroll end');
        $show->sponsor('Sponsor');
        $show->address('Address');
        $show->contact('Contact');
        $show->content('Content');
        $show->created_at('Created at');
        $show->updated_at('Updated at');

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Activity);

        $form->text('title', '名称')->rules('required');;
        //$form->datetime('start', '开始时间')->rules('required');;
        //$form->datetime('end', '结束时间')->rules('required');
        $form->datetimeRange('start', 'end', '活动时间')->rules('required');
        //$form->datetime('enroll_start', '报名开始时间')->rules('required');;
        //$form->datetime('enroll_end', '报名结束时间')->rules('required');;
        $form->datetimeRange('enroll_start', 'enroll_end', '报名时间')->rules('required');
        $form->image('cover', '封面图')->rules('required');;
        $form->currency('price', '报名费')->symbol('￥')->rules('required');
        $form->text('sponsor', '主办人')->rules('required');
        $form->text('address', '地址')->rules('required');
        $form->text('contact', '联系人')->rules('required');
        $form->number('limit', '数量限制')->default(0)->help('0为不限制人数');
        $form->textarea('introduction', '简介')->rules('required');
        $form->editor('content', '内容')->rules('required');

        return $form;
    }
}
