<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEnrollmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('enrollments', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id')->comment('用户ID');
            $table->unsignedInteger('activity_id')->comment('活动ID');
            $table->string('name', 50)->comment('姓名');
            $table->string('mobile', 20)->comment('手机号');
            $table->string('company')->comment('公司');
            $table->string('recommender', 50)->nullable()->comment('推荐人');
            $table->boolean('pay_status')->default(false)->comment('是否支付报名费');
            $table->unique(['user_id', 'activity_id']);
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('activity_id')->references('id')->on('activities')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('enrollments');
    }
}
