<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activities', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title')->comment('活动名称');
            $table->timestamp('start')->nullable()->comment('开始日期');
            $table->timestamp('end')->nullable()->comment('结束日期');
            $table->timestamp('enroll_start')->nullable()->comment('报名开始日期');
            $table->timestamp('enroll_end')->nullable()->comment('报名结束日期');
            $table->string('sponsor')->comment('主办人');
            $table->string('address')->comment('位置');
            $table->string('contact')->comment('联系信息');
            $table->text('content')->comment('详情');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activities');
    }
}
