<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOpenidsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('openids', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type');
            $table->string('openid');
            $table->integer('user_id');
            $table->unique(['type', 'openid']);
            $table->json('extra')->nullable()->comment('额外信息');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('openids');
    }
}
